#include <bits/stdc++.h>
using namespace std;

struct Item {
    long long w, v;
    int id;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N;
    long long W;
    double eps;
    cin >> N >> W >> eps;

    vector<long long> w(N+1), v(N+1);
    long long vmax = 0;
    for (int i = 1; i <= N; i++) {
        cin >> w[i] >> v[i];
        vmax = max(vmax, v[i]);
    }

    if (N == 0 || W <= 0 || vmax == 0) {
        cout << 0 << "\n\n";
        return 0;
    }

    // Scaling factor
    long double K = (long double)eps * (long double)vmax / (long double)N;
    if (K <= 0) K = 1.0L;

    vector<int> vp(N+1);
    long long S = 0;
    for (int i = 1; i <= N; i++) {
        vp[i] = (int)floor((long double)v[i] / K);
        if (vp[i] < 0) vp[i] = 0;
        S += vp[i];
    }

    // If all vp are 0, best is to pack by v/w greedily (since DP is useless).
    if (S == 0) {
        vector<Item> items;
        items.reserve(N);
        for (int i = 1; i <= N; i++) items.push_back({w[i], v[i], i});

        sort(items.begin(), items.end(), [](const Item& a, const Item& b) {
            // compare a.v/a.w > b.v/b.w without floating
            __int128 lhs = (__int128)a.v * b.w;
            __int128 rhs = (__int128)b.v * a.w;
            if (lhs != rhs) return lhs > rhs;
            return a.v > b.v;
        });

        long long cap = W;
        vector<int> chosen;
        for (auto &it : items) {
            if (it.w <= cap) {
                cap -= it.w;
                chosen.push_back(it.id);
            }
        }

        sort(chosen.begin(), chosen.end());
        cout << chosen.size() << "\n";
        for (int i = 0; i < (int)chosen.size(); i++) {
            if (i) cout << " ";
            cout << chosen[i];
        }
        cout << "\n";
        return 0;
    }

    const long long INF = (1LL<<62);

    vector<long long> dp(S+1, INF);
    dp[0] = 0;

    // parent pointers for reconstruction (works with descending s loop)
    vector<int> parentS(S+1, -1), parentItem(S+1, -1);

    for (int i = 1; i <= N; i++) {
        int add = vp[i];
        if (add == 0) continue;
        for (int s = (int)S; s >= add; s--) {
            if (dp[s - add] == INF) continue;
            long long cand = dp[s - add] + w[i];
            if (cand < dp[s]) {
                dp[s] = cand;
                parentS[s] = s - add;
                parentItem[s] = i;
            }
        }
    }

    // best scaled value within W
    int bestS = 0;
    for (int s = 0; s <= (int)S; s++) {
        if (dp[s] <= W) bestS = s;
    }

    vector<char> used(N+1, 0);
    vector<int> chosen;
    int cur = bestS;
    while (cur > 0 && parentItem[cur] != -1) {
        int it = parentItem[cur];
        if (!used[it]) {
            used[it] = 1;
            chosen.push_back(it);
        }
        cur = parentS[cur];
    }

    long long usedW = 0;
    for (int id : chosen) usedW += w[id];
    long long cap = W - usedW;

    // ? crucial: add vp==0 items greedily into remaining capacity
    vector<Item> zeros;
    zeros.reserve(N);
    for (int i = 1; i <= N; i++) {
        if (!used[i] && vp[i] == 0) zeros.push_back({w[i], v[i], i});
    }

    sort(zeros.begin(), zeros.end(), [](const Item& a, const Item& b) {
        __int128 lhs = (__int128)a.v * b.w;
        __int128 rhs = (__int128)b.v * a.w;
        if (lhs != rhs) return lhs > rhs;
        return a.v > b.v;
    });

    for (auto &it : zeros) {
        if (it.w <= cap) {
            cap -= it.w;
            used[it.id] = 1;
            chosen.push_back(it.id);
        }
    }

    sort(chosen.begin(), chosen.end());
    cout << chosen.size() << "\n";
    for (int i = 0; i < (int)chosen.size(); i++) {
        if (i) cout << " ";
        cout << chosen[i];
    }
    cout << "\n";
    return 0;
}